﻿var openEndAnalysisTopicDocuments = {
    context: $(".open-end-analysis-topic-documents"),
    dataTable: null,
    initialize: function () {
        openEndAnalysisTopicDocuments.initializeDataTable();
    },
    initializeDataTable: function () {
        var variable = $("#Variable", openEndAnalysisTopicDocuments.context).val();
        var topic = $("#Topic", openEndAnalysisTopicDocuments.context).val();

        openEndAnalysisTopicDocuments.dataTable = $(".data-table", this.context).a4datatable({
            height: "full",
            ajaxAction: a4.getSurveyAction("GetOpenEndAnalysisDocuments", "Analyze"),
            ajaxParams: { "variable": variable, "topics": [topic] },
            columns: [
                { "Name": "Id", "Title": resources.Id, "Visible": false, "Key": true },
                { "Name": "RespondentId", "Title": resources.Respondent, "Width": "80px" },
                { "Name": "Matrix", "Title": resources.Matrix, "Width": "80px" },
                { "Name": "Mention", "Title": resources.Mention, "Width": "80px" },
                { "Name": "Text", "Title": resources.OpenEnd, "HideInSelector": true, "Class": "text-column", "Data": openEndAnalysis.renderTextWithTopics },
                { "Name": "Score", "Title": resources.Score, "Width": "80px", "Type": "Number" },
                { "Name": "Sentiment", "Title": resources.Sentiment, "Width": "150px", "Class": "sentiment-column", "Data": openEndAnalysis.renderSentimentChart }
            ]
        });
    }
};

$(document).ready(function () {
    if (openEndAnalysisTopicDocuments.context.length > 0)
        openEndAnalysisTopicDocuments.initialize();
})